package mole.entities.items 
{
	import mole.Main;
	import mole.entities.ICollectable;
	import mole.entities.CPlayer;
	import mole.entities.items.IItem;
	import net.flashpunk.Entity;
	import mole.entities.CItemsAssets;
	import net.flashpunk.graphics.Image;
	
	/**
	 * Représentation d'un item de type Collier.
	 * @author Cédric Liaudet
	 */
	public class CNecklace extends IItem
	{
		/**
		 * Constructeur.
		 */
		function CNecklace(_PosX:Number, _PosY:Number, _nType:int)
		{
			super(_PosX, _PosY, _nType);
			
			var image:Image = new Image(CItemsAssets.s_Sprites[CItemsAssets.NECKLACE]);			
			width = image.width;
			height = image.height;
			
			graphic = image;
		}
		
		/**
		 * Callback quand un personnage rammasse l'item.
		 * @param	_Player Le personnage qui collecte l'objet.
		 */
		override public function OnCollected(_Player:CPlayer):void
		{
			super.OnDestroy();			
		}
	}
	
}